<?php
include 'db.php';

// Statistiques globales
$nb_articles = $pdo->query("SELECT COUNT(*) FROM articles")->fetchColumn();
$total_quantite = $pdo->query("SELECT SUM(quantite) FROM articles")->fetchColumn();
$articles_alertes = $pdo->query("SELECT COUNT(*) FROM articles WHERE quantite < seuil")->fetchColumn();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Tableau de bord</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
  <div class="container mt-5">
    <h2 class="mb-4">Tableau de bord</h2>
    <div class="row mb-4">
      <div class="col-md-4">
        <div class="card text-white bg-primary mb-3">
          <div class="card-body">
            <h5 class="card-title">Articles enregistrés</h5>
            <p class="card-text fs-4"><?php echo $nb_articles; ?></p>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card text-white bg-success mb-3">
          <div class="card-body">
            <h5 class="card-title">Quantité totale</h5>
            <p class="card-text fs-4"><?php echo $total_quantite; ?></p>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card text-white bg-danger mb-3">
          <div class="card-body">
            <h5 class="card-title">Articles en alerte</h5>
            <p class="card-text fs-4"><?php echo $articles_alertes; ?></p>
          </div>
        </div>
      </div>
    </div>

    <h3 class="mb-3">Répartition des articles par catégorie</h3>
    <canvas id="pieChart" height="100"></canvas>
    <script>
    fetch('stats_api.php')
      .then(res => res.json())
      .then(data => {
        const ctx = document.getElementById('pieChart');
        new Chart(ctx, {
          type: 'pie',
          data: {
            labels: data.labels,
            datasets: [{
              data: data.values,
              backgroundColor: ['#007bff','#28a745','#dc3545','#ffc107','#17a2b8']
            }]
          }
        });
      });
    </script>
  </div>
</body>
</html>
