<?php
require('fpdf.php');
include 'db.php';

// Récupérer les mouvements des 7 derniers jours
$stmt = $pdo->prepare("
    SELECT m.date_mouvement, a.nom AS article, m.type, m.quantite, m.commentaire
    FROM mouvements m
    JOIN articles a ON m.article_id = a.id
    WHERE m.date_mouvement >= NOW() - INTERVAL 7 DAY
    ORDER BY m.date_mouvement DESC
");
$stmt->execute();
$mouvements = $stmt->fetchAll();

// Génération PDF
class PDF extends FPDF {
    function Header() {
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'Mouvements de Stock (7 derniers jours)',0,1,'C');
        $this->Ln(5);
        $this->SetFont('Arial','B',10);
        $this->Cell(40,7,'Date',1);
        $this->Cell(60,7,'Article',1);
        $this->Cell(20,7,'Type',1);
        $this->Cell(20,7,'Quantite',1);
        $this->Cell(50,7,'Commentaire',1);
        $this->Ln();
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','',10);

foreach ($mouvements as $row) {
    $pdf->Cell(40,6,$row['date_mouvement'],1);
    $pdf->Cell(60,6,utf8_decode($row['article']),1);
    $pdf->Cell(20,6,$row['type'],1);
    $pdf->Cell(20,6,$row['quantite'],1);
    $pdf->Cell(50,6,utf8_decode($row['commentaire']),1);
    $pdf->Ln();
}

$pdf->Output('D', 'mouvements_stock.pdf');
exit;
?>
