<?php
include 'db.php';
$stmt = $pdo->query("SELECT mouvements.*, articles.nom AS article FROM mouvements JOIN articles ON mouvements.article_id = articles.id ORDER BY date_mouvement DESC");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Historique des mouvements</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
  <div class="container mt-5">
    <h2>Historique des mouvements</h2>
    <table class="table table-bordered">
      <thead class="table-dark">
        <tr><th>Article</th><th>Type</th><th>Quantité</th><th>Date</th><th>Commentaire</th></tr>
      </thead>
      <tbody>
        <?php while ($row = $stmt->fetch()) {
          echo "<tr>
            <td>{$row['article']}</td>
            <td>{$row['type']}</td>
            <td>{$row['quantite']}</td>
            <td>{$row['date_mouvement']}</td>
            <td>{$row['commentaire']}</td>
          </tr>";
        } ?>
      </tbody>
    </table>
  </div>
</body>
</html>
